/*
 * Decompiled with CFR 0.152.
 */
package pt.caf_pbs.schooldiskapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import pt.caf_pbs.schooldiskapi.exceptions.DuplicatedDataException;
import pt.caf_pbs.schooldiskapi.model.Instructor;

@JsonIgnoreProperties(value={"all"})
public class InstructorContainer
implements Serializable {
    private List<Instructor> instructors = new ArrayList();

    public List<Instructor> getInstructors() {
        return this.instructors;
    }

    public void setInstructors(List<Instructor> instructors) {
        this.instructors = instructors;
    }

    private Instructor search(String initials) {
        for (Instructor instructor : this.instructors) {
            if (!instructor.isEqualTo(initials)) continue;
            return instructor;
        }
        return null;
    }

    public List<Instructor> getAll() {
        ArrayList<Instructor> newlist = new ArrayList<Instructor>();
        newlist.addAll(this.instructors);
        return newlist;
    }

    public Instructor get(String initials) {
        Instructor instructor = this.search(initials);
        return instructor;
    }

    public void add(Instructor obj) {
        Instructor instructor = this.search(obj.getInitials());
        if (instructor != null) {
            String msg = "Instructor: " + obj.getInitials() + " already exists";
            throw new DuplicatedDataException(msg);
        }
        this.instructors.add(obj);
    }

    public void remove(String initials) {
        Instructor instructor = this.search(initials);
        if (instructor != null) {
            this.instructors.remove(instructor);
        }
    }

    public void update(String initials, String name) {
        Instructor instructor = this.search(initials);
        if (instructor != null) {
            instructor.setName(name);
        }
    }
}

